package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.ClaseCentroTrabajoDao;
import com.ejie.ab04b.model.ClaseCentroTrabajo;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ClaseCentroTrabajoServiceImpl generated by UDA, 27-dic-2016 12:43:15.
 * 
 * @author UDA
 */

@Service(value = "claseCentroTrabajoService")
public class ClaseCentroTrabajoServiceImpl implements ClaseCentroTrabajoService {

	@Autowired()
	private ClaseCentroTrabajoDao claseCentroTrabajoDao;

	/**
	 * Inserts a single row in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  ClaseCentroTrabajo
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @return the clase centro trabajo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ClaseCentroTrabajo add(ClaseCentroTrabajo claseCentroTrabajo) {
		return this.claseCentroTrabajoDao.add(claseCentroTrabajo);
	}

	/**
	 * Updates a single row in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  ClaseCentroTrabajo
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @return the clase centro trabajo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ClaseCentroTrabajo update(ClaseCentroTrabajo claseCentroTrabajo) {
		return this.claseCentroTrabajoDao.update(claseCentroTrabajo);
	}

	/**
	 * Finds a single row in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  ClaseCentroTrabajo
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @return the clase centro trabajo
	 */
	public ClaseCentroTrabajo find(ClaseCentroTrabajo claseCentroTrabajo) {
		return (ClaseCentroTrabajo) this.claseCentroTrabajoDao.find(claseCentroTrabajo);
	}

	/**
	 * Deletes a single row in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ClaseCentroTrabajo claseCentroTrabajo) {
		this.claseCentroTrabajoDao.remove(claseCentroTrabajo);
	}

	/**
	 * Finds a list of rows in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<ClaseCentroTrabajo>
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<ClaseCentroTrabajo> findAll(ClaseCentroTrabajo claseCentroTrabajo, JQGridRequestDto jqGridRequestDto) {
		return (List<ClaseCentroTrabajo>) this.claseCentroTrabajoDao.findAll(claseCentroTrabajo, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab04b72s00 table using like.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<ClaseCentroTrabajo>
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<ClaseCentroTrabajo> findAllLike(ClaseCentroTrabajo claseCentroTrabajo, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return (List<ClaseCentroTrabajo>) this.claseCentroTrabajoDao.findAllLike(claseCentroTrabajo, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab04b72s00 table.
	 * 
	 *  filterClaseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(ClaseCentroTrabajo filterClaseCentroTrabajo, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		this.claseCentroTrabajoDao.removeMultiple(filterClaseCentroTrabajo, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab04b72s00 table.
	 * 
	 *  filterClaseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<ClaseCentroTrabajo>
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ClaseCentroTrabajo> filter(ClaseCentroTrabajo filterClaseCentroTrabajo,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<ClaseCentroTrabajo> listaClaseCentroTrabajo = this.claseCentroTrabajoDao.findAllLike(filterClaseCentroTrabajo, jqGridRequestDto,
				false);
		Long recordNum = this.claseCentroTrabajoDao
				.findAllLikeCount(filterClaseCentroTrabajo != null ? filterClaseCentroTrabajo : new ClaseCentroTrabajo(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<ClaseCentroTrabajo>> reorderSelection = this.claseCentroTrabajoDao
					.reorderSelection(filterClaseCentroTrabajo, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<ClaseCentroTrabajo>(jqGridRequestDto, recordNum, listaClaseCentroTrabajo,
					reorderSelection);
		}
		return new JQGridResponseDto<ClaseCentroTrabajo>(jqGridRequestDto, recordNum, listaClaseCentroTrabajo);
	}

	/**
	 * Searches rows in the Ab04b72s00 table.
	 * 
	 *  filterClaseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  searchClaseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<ClaseCentroTrabajo>>
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param searchClaseCentroTrabajo the search clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<ClaseCentroTrabajo>> search(ClaseCentroTrabajo filterClaseCentroTrabajo,
			ClaseCentroTrabajo searchClaseCentroTrabajo, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.claseCentroTrabajoDao.search(filterClaseCentroTrabajo, searchClaseCentroTrabajo, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab04b72s00 table.
	 * 
	 *  filterClaseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(ClaseCentroTrabajo filterClaseCentroTrabajo, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.claseCentroTrabajoDao.reorderSelection(filterClaseCentroTrabajo, jqGridRequestDto, startsWith);
	}

}
